IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_CHQ_EMI_BLOQUEIA_CHQ_ANONIMIZADO' )
BEGIN
	DROP TRIGGER TRG_CHQ_EMI_BLOQUEIA_CHQ_ANONIMIZADO
END
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: TRG_CHQ_EMI_BLOQUEIA_CHQ_ANONIMIZADO 
'Objetivo............: Tratamento para nao alteracao do cheque Anonimizado
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 30/07/2021
'Alterado por........: 
'Criado por..........: Marcos Barros 
'=======================================================================================
*/
CREATE TRIGGER TRG_CHQ_EMI_BLOQUEIA_CHQ_ANONIMIZADO ON CHQ_EMI FOR UPDATE AS
	DECLARE @CD_EMI INT
	IF UPDATE (CD_EMI)
	BEGIN
		RETURN;
	END
	SET @CD_EMI = ISNULL((SELECT CD_EMI FROM inserted),0);

	IF EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO 
				WHERE
					CD_PESSOA = @CD_EMI
					AND TP_PROC = 1)
	  begin
		RAISERROR ('ALTERACAO NO PERMITIDA, CADASTRO ANONIMIZADO!',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end

GO

ALTER TABLE CHQ_EMI ENABLE TRIGGER TRG_CHQ_EMI_BLOQUEIA_CHQ_ANONIMIZADO